/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarContainer;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;

final class DnDSupport
implements DragSourceListener,
DragGestureListener,
DropTargetListener,
DragSourceMotionListener {
    private final ToolbarConfiguration config;
    private static final DataFlavor buttonDataFlavor = new DataFlavor(DataObject.class, "Toolbar Item");
    private static final DataFlavor actionDataFlavor = new DataFlavor(Node.class, "Action Node");
    private static final DataFlavor toolbarDataFlavor = new DataFlavor(ToolbarContainer.class, "Toolbar Container");
    private final DragSource dragSource = DragSource.getDefaultDragSource();
    private static final Cursor dragMoveCursor = DragSource.DefaultMoveDrop;
    private static final Cursor dragNoDropCursor = DragSource.DefaultMoveNoDrop;
    private Cursor dragRemoveCursor;
    private final Map<Component, DragGestureRecognizer> recognizers = new HashMap<Component, DragGestureRecognizer>();
    private boolean buttonDndAllowed = false;
    private Toolbar currentToolbar;
    private Toolbar sourceToolbar;
    private int dropTargetButtonIndex = -1;
    private int dragSourceButtonIndex = -1;
    private boolean insertBefore = true;
    private ToolbarContainer sourceContainer;
    private ToolbarRow currentRow;
    private ToolbarRow sourceRow;
    private Point startingPoint;
    private Window dragWindow;
    private Image dragImage;
    private boolean isToolbarDrag;
    private boolean isButtonDrag;
    private final Logger log = Logger.getLogger(DnDSupport.class.getName());
    private static final int SLIDE_INTERVAL = 33;

    public DnDSupport(ToolbarConfiguration toolbarConfiguration) {
        this.config = toolbarConfiguration;
        this.dragSource.addDragSourceMotionListener(this);
        this.dragRemoveCursor = Utilities.createCustomCursor((Component)ToolbarPool.getDefault(), (Image)ImageUtilities.loadImage((String)"org/netbeans/core/windows/resources/delete.gif"), (String)"NO_ACTION_MOVE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Component component) {
        Map<Component, DragGestureRecognizer> map = this.recognizers;
        synchronized (map) {
            DragGestureRecognizer dragGestureRecognizer = this.recognizers.get(component);
            if (null == dragGestureRecognizer) {
                dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(component, 2, this);
                this.recognizers.put(component, dragGestureRecognizer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Component component) {
        Map<Component, DragGestureRecognizer> map = this.recognizers;
        synchronized (map) {
            DragGestureRecognizer dragGestureRecognizer = this.recognizers.get(component);
            if (null != dragGestureRecognizer) {
                dragGestureRecognizer.setComponent(null);
            }
            this.recognizers.remove(component);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        if (this.isButtonDrag) {
            this.resetDropGesture();
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (this.isButtonDrag) {
            Component component = dragSourceDropEvent.getDragSourceContext().getComponent();
            if (component instanceof JButton) {
                ((JButton)component).getModel().setRollover(false);
            }
            component.repaint();
            this.resetDropGesture();
            if (!dragSourceDropEvent.getDropSuccess() && !this.isInToolbarPanel(WindowDnDManager.getLocationWorkaround(dragSourceDropEvent))) {
                this.removeButton(dragSourceDropEvent.getDragSourceContext().getTransferable());
            }
        } else if (this.isToolbarDrag) {
            Point point = null;
            boolean bl = false;
            if (null != this.currentRow) {
                point = this.currentRow.drop();
                if (this.sourceRow != this.currentRow) {
                    this.sourceRow.dragSuccess();
                    this.config.removeEmptyRows();
                }
                bl = true;
            } else if (null != this.sourceRow) {
                point = this.sourceRow.dragAbort();
                bl = true;
            }
            if (null != this.dragWindow) {
                if (null != point) {
                    this.animateDragWindow(point);
                } else {
                    this.dragWindow.dispose();
                }
                this.dragWindow = null;
            }
            this.config.maybeRemoveLastRow();
            if (bl) {
                this.config.refresh();
                this.config.save();
            }
        }
        this.isButtonDrag = false;
        this.isToolbarDrag = false;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Component component = dragGestureEvent.getComponent();
        if (!(component instanceof JComponent)) {
            return;
        }
        ExTransferable.Single single = null;
        try {
            ToolbarContainer toolbarContainer;
            final DataObject dataObject = (DataObject)((JComponent)component).getClientProperty("file");
            if (dataObject != null && component.getParent() instanceof Toolbar && this.buttonDndAllowed) {
                this.sourceToolbar = (Toolbar)component.getParent();
                single = new ExTransferable.Single(buttonDataFlavor){

                    public Object getData() {
                        return dataObject;
                    }
                };
                this.isToolbarDrag = false;
                this.isButtonDrag = true;
                this.dragSourceButtonIndex = this.sourceToolbar.getComponentIndex(component);
            } else if (Boolean.TRUE.equals(((JComponent)component).getClientProperty("_toolbar_dragger_")) && (toolbarContainer = (ToolbarContainer)component.getParent().getParent()).isShowing()) {
                this.sourceContainer = toolbarContainer;
                this.sourceRow = (ToolbarRow)toolbarContainer.getParent();
                single = new ExTransferable.Single(toolbarDataFlavor){

                    public Object getData() {
                        return toolbarContainer;
                    }
                };
                this.isToolbarDrag = true;
                this.isButtonDrag = false;
                this.startingPoint = new Point(dragGestureEvent.getDragOrigin());
                Rectangle rectangle = new Rectangle(this.sourceContainer.getPreferredSize());
                rectangle.setLocation(this.sourceContainer.getLocationOnScreen());
                this.dragImage = this.createContentImage(this.sourceContainer, rectangle.getSize());
                this.sourceRow.dragStarted(this.sourceContainer);
                this.dragWindow = this.createDragWindow(this.dragImage, rectangle);
            }
            if (component instanceof JButton) {
                ((JButton)component).getModel().setArmed(false);
                ((JButton)component).getModel().setPressed(false);
                ((JButton)component).getModel().setRollover(true);
            }
            if (single != null) {
                dragGestureEvent.startDrag(dragMoveCursor, (Transferable)single, this);
            }
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            this.log.log(Level.INFO, null, invalidDnDOperationException);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        try {
            if (this.isButtonDrag) {
                if (this.validateDropPosition()) {
                    bl = this.handleDrop(dropTargetDropEvent.getTransferable());
                }
            } else if (this.isToolbarDrag) {
                bl = true;
            }
        }
        finally {
            dropTargetDropEvent.dropComplete(bl);
        }
        this.resetDropGesture();
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.resetDropGesture();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(buttonDataFlavor) || dropTargetDragEvent.isDataFlavorSupported(actionDataFlavor)) {
            dropTargetDragEvent.acceptDrag(3);
            this.isButtonDrag = true;
        } else if (dropTargetDragEvent.isDataFlavorSupported(toolbarDataFlavor)) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(buttonDataFlavor) || dropTargetDragEvent.isDataFlavorSupported(actionDataFlavor)) {
            this.updateDropGesture(dropTargetDragEvent);
            if (!this.validateDropPosition()) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(3);
            }
        } else if (dropTargetDragEvent.isDataFlavorSupported(toolbarDataFlavor)) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
        Point point = WindowDnDManager.getLocationWorkaround(dragSourceDragEvent);
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        if (this.isButtonDrag) {
            int n = dragSourceDragEvent.getDropAction();
            if ((n & 2) != 0) {
                dragSourceContext.setCursor(dragMoveCursor);
            } else if (this.isInToolbarPanel(point)) {
                dragSourceContext.setCursor(dragNoDropCursor);
            } else {
                dragSourceContext.setCursor(this.dragRemoveCursor);
            }
        } else if (this.isToolbarDrag && null != this.dragWindow) {
            Point point2 = new Point(point);
            point2.x -= this.startingPoint.x;
            point2.y -= this.startingPoint.y;
            this.dragWindow.setLocation(point2);
            dragSourceContext.setCursor(Cursor.getPredefinedCursor(13));
            ToolbarRow toolbarRow = this.config.getToolbarRowAt(point);
            if (!(null != toolbarRow || this.sourceRow.countVisibleToolbars() <= 1 && this.config.isLastRow(this.sourceRow))) {
                toolbarRow = this.config.maybeAddEmptyRow(point);
            }
            ToolbarRow toolbarRow2 = this.currentRow;
            this.currentRow = toolbarRow;
            if (null != toolbarRow2 && toolbarRow2 != this.currentRow) {
                toolbarRow2.hideDropFeedback();
                this.config.repaint();
            }
            if (null != this.currentRow) {
                this.currentRow.showDropFeedback(this.sourceContainer, point, this.dragImage);
            }
            if (!this.config.isLastRow(this.currentRow)) {
                this.config.maybeRemoveLastRow();
            }
        }
    }

    void setButtonDragAndDropAllowed(boolean bl) {
        this.buttonDndAllowed = bl;
    }

    boolean isButtonDragAndDropAllowed() {
        return this.buttonDndAllowed;
    }

    private Window createDragWindow(Image image, Rectangle rectangle) {
        Window window = new Window(SwingUtilities.windowForComponent(this.sourceRow));
        window.add(new JLabel(ImageUtilities.image2Icon((Image)image)));
        window.setBounds(rectangle);
        window.setVisible(true);
        NativeWindowSystem nativeWindowSystem = NativeWindowSystem.getDefault();
        if (nativeWindowSystem.isUndecoratedWindowAlphaSupported()) {
            nativeWindowSystem.setWindowAlpha(window, 0.7f);
        }
        return window;
    }

    private BufferedImage createContentImage(JComponent jComponent, Dimension dimension) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        boolean bl = jComponent.isOpaque();
        jComponent.setOpaque(true);
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(dimension.width, dimension.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(jComponent.getBackground());
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        jComponent.paint(graphics2D);
        jComponent.setOpaque(bl);
        return bufferedImage;
    }

    private void animateDragWindow(final Point point) {
        final Timer timer = new Timer(33, null);
        final Window window = this.dragWindow;
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Point point3 = window.getLocationOnScreen();
                Point point2 = new Point(point);
                int n = (point2.x - point3.x) / 2;
                int n2 = (point2.y - point3.y) / 2;
                if (n != 0 || n2 != 0) {
                    point3.translate(n, n2);
                    window.setLocation(point3);
                } else {
                    timer.stop();
                    window.dispose();
                }
            }
        });
        timer.setInitialDelay(0);
        timer.start();
    }

    private boolean isInToolbarPanel(Point point) {
        ToolbarPool toolbarPool = ToolbarPool.getDefault();
        SwingUtilities.convertPointFromScreen(point, (Component)toolbarPool);
        return toolbarPool.contains(point);
    }

    private DataFolder getBackingFolder(Toolbar toolbar) {
        Object object = toolbar.getClientProperty((Object)"folder");
        if (object instanceof DataFolder) {
            return (DataFolder)object;
        }
        return null;
    }

    private boolean addButton(DataObject dataObject, int n, boolean bl) throws IOException {
        if (null == dataObject) {
            return false;
        }
        String string = dataObject.getName();
        DataFolder dataFolder = this.getBackingFolder(this.currentToolbar);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (!string.equals(dataObjectArray[i].getName())) continue;
            return this.moveButton(dataObjectArray[i], n, bl);
        }
        DataObject dataObject2 = this.getDataObjectUnderDropCursor(n - 1, bl);
        DataShadow dataShadow = DataShadow.create((DataFolder)dataFolder, (DataObject)dataObject);
        dataShadow.getPrimaryFile().setAttribute("position", (Object)100001);
        DataObject dataObject3 = null;
        dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (!string.equals(dataObjectArray[i].getName())) continue;
            dataObject3 = dataObjectArray[i];
            break;
        }
        if (null != dataObject3) {
            this.reorderButtons(dataObject3, dataObject2);
        }
        return true;
    }

    private boolean moveButton(DataObject dataObject, int n, boolean bl) throws IOException {
        DataObject dataObject2 = this.getDataObjectUnderDropCursor(n - 1, bl);
        if (this.sourceToolbar != this.currentToolbar) {
            dataObject.move(this.getBackingFolder(this.currentToolbar));
        }
        this.reorderButtons(dataObject, dataObject2);
        return true;
    }

    private void reorderButtons(DataObject dataObject, DataObject dataObject2) throws IOException {
        DataFolder dataFolder = this.getBackingFolder(this.currentToolbar);
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(Arrays.asList(dataFolder.getChildren()));
        if (null == dataObject2) {
            arrayList.remove(dataObject);
            arrayList.add(dataObject);
        } else {
            int n = arrayList.indexOf(dataObject2);
            int n2 = arrayList.indexOf(dataObject);
            if (n2 < n) {
                --n;
            }
            n = Math.max(0, n);
            n = Math.min(arrayList.size(), n);
            arrayList.remove(dataObject);
            arrayList.add(n, dataObject);
        }
        dataFolder.setOrder(arrayList.toArray(new DataObject[0]));
    }

    private DataObject getDataObjectUnderDropCursor(int n, boolean bl) {
        DataObject[] dataObjectArray = this.getBackingFolder(this.currentToolbar).getChildren();
        DataObject dataObject = null;
        if (dataObjectArray.length > 0) {
            if (!bl) {
                ++n;
            }
            if (n < dataObjectArray.length && n >= 0) {
                dataObject = dataObjectArray[n];
            }
        }
        return dataObject;
    }

    private boolean validateDropPosition() {
        return this.dropTargetButtonIndex >= 0;
    }

    private void updateDropGesture(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (component instanceof Toolbar) {
            ToolbarContainer toolbarContainer;
            boolean bl;
            Toolbar toolbar = (Toolbar)component;
            Component component2 = toolbar.getComponentAt(point);
            int n = toolbar.getComponentIndex(component2);
            boolean bl2 = bl = point.x <= component2.getLocation().x + component2.getWidth() / 2;
            if (n != this.dropTargetButtonIndex || bl != this.insertBefore) {
                this.dropTargetButtonIndex = n;
                this.insertBefore = bl;
            }
            if (null != this.currentToolbar) {
                toolbarContainer = this.getContainer(this.currentToolbar);
                toolbarContainer.setDropGesture(-1, false);
            }
            this.currentToolbar = toolbar;
            toolbarContainer = this.getContainer(this.currentToolbar);
            toolbarContainer.setDropGesture(this.dropTargetButtonIndex, this.insertBefore);
        } else {
            this.resetDropGesture();
            this.currentToolbar = null;
        }
    }

    private void resetDropGesture() {
        this.dropTargetButtonIndex = -1;
        if (null != this.currentToolbar) {
            ToolbarContainer toolbarContainer = this.getContainer(this.currentToolbar);
            toolbarContainer.setDropGesture(-1, false);
        }
    }

    private ToolbarContainer getContainer(Toolbar toolbar) {
        return (ToolbarContainer)toolbar.getParent();
    }

    private void removeButton(Transferable transferable) {
        try {
            Object object = null;
            if (transferable.isDataFlavorSupported(buttonDataFlavor)) {
                object = transferable.getTransferData(buttonDataFlavor);
            }
            if (object instanceof DataObject) {
                ((DataObject)object).delete();
                this.sourceToolbar.repaint();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.log.log(Level.INFO, null, unsupportedFlavorException);
        }
        catch (IOException iOException) {
            this.log.log(Level.INFO, null, iOException);
        }
    }

    private boolean handleDrop(final Transferable transferable) {
        final boolean[] blArray = new boolean[]{false};
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                blArray[0] = DnDSupport.this.handleDropImpl(transferable);
            }
        });
        return blArray[0];
    }

    private boolean handleDropImpl(Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(actionDataFlavor)) {
                Object object = transferable.getTransferData(actionDataFlavor);
                if (object instanceof Node) {
                    DataObject dataObject = (DataObject)((Node)object).getLookup().lookup(DataObject.class);
                    return this.addButton(dataObject, this.dropTargetButtonIndex, this.insertBefore);
                }
            } else {
                Object object = transferable.getTransferData(buttonDataFlavor);
                if (object instanceof DataObject) {
                    return this.moveButton((DataObject)object, this.dropTargetButtonIndex, this.insertBefore);
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.log.log(Level.INFO, null, unsupportedFlavorException);
        }
        catch (IOException iOException) {
            this.log.log(Level.INFO, null, iOException);
        }
        return false;
    }
}

